; Program : Simple serial port echo program to test wiring etc to/from
;           EVM host serial port. Every character typed on PC will be echoed
;           back to the PC and the PTT LED will flash once. The interface board
;           used was the evm56k.sch by ZS6AWK. (based on KC7WW's version)
;           Use a terminal program on PC set to 19200 baud for comms to EVM.
; Author  : Danie Brynard ZS6AWK email: danie.brynard@pixie.co.za
; File    : tstsci.asm
; Update  : 29/7/95
; Target  : DSP56002EVM from Motorola REV2.2
; Notes   : Load BIOS.ASM ver-4/95 from KC7WW before loading program
; Status  : works 100%

        include 'leonid'
        org     p:user_code

        move    #0,a1      ; normal mode NOT KISS
        opensc
        move    #>'E',x0
        putc
        move    #>'V',x0
        putc
        move    #>'M',x0
        putc
        move    #>'.',x0
loop    
        getc
        putc                ; echo character back
        jsr     inc_x0
        putc
        bset   #0,x:$FFE4  ; toggle transmitter PTT control
        jsr    delay
        bclr   #0,x:$FFE4
        jmp     loop

inc_x0  move    #>1,a           ; increment x0 by 1
        add     x0,a
        move    a,x0
        rts

delay   do      #500,_d_loop    ; create a 50ms delay
	rep     #2000           ; 100 us delay
	nop
_d_loop
        rts

        end

